<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Support')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <ul class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>"><h1><?php echo e(__('Dashboard')); ?></h1></a>
        </li>
        <li class="breadcrumb-item active">
            <a href="#"><?php echo e(__('Support')); ?></a>
        </li>
    </ul>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('card-action-btn'); ?>
    <?php if(Gate::check('create support') || \Auth::user()->type=='super admin'): ?>
        <a class="btn btn-primary btn-sm ml-20 customModal" href="#" data-size="md"
           data-url="<?php echo e(route('support.create')); ?>"
           data-title="<?php echo e(__('Create Support')); ?>"> <i class="ti-plus mr-5"></i><?php echo e(__('Create Support')); ?></a>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table class="display dataTable cell-border datatbl-advance">
                        <thead>
                        <tr>
                            <th><?php echo e(__('Subject')); ?></th>
                            <th><?php echo e(__('Attachment')); ?></th>
                            <th><?php echo e(__('Created Date')); ?></th>
                            <th><?php echo e(__('Created By')); ?></th>
                            <th><?php echo e(__('Assign User')); ?></th>
                            <th><?php echo e(__('Priority')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <?php if(Gate::check('edit support') ||  Gate::check('delete support') || Gate::check('reply support') ||  \Auth::user()->type=='super admin'): ?>
                                <th class="text-right"><?php echo e(__('Action')); ?></th>
                            <?php endif; ?>

                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $supports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $support): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr role="row">
                                <td>
                                    <a href="<?php echo e(route('support.show',\Crypt::encrypt($support->id))); ?>"
                                       class="text-body"><?php echo e($support->subject); ?></a>
                                </td>
                                <td>
                                    <?php if(!empty($support->attachment)): ?>
                                        <a href="<?php echo e(asset('/storage/upload/support/'.$support->attachment)); ?>"
                                           download=""><i
                                                data-feather="download"></i></a>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo e(\Auth::user()->dateFormat($support->created_at)); ?>

                                </td>
                                <td>
                                    <?php echo e(!empty($support->createdUser)?$support->createdUser->name:'-'); ?>

                                </td>
                                <td>
                                    <?php echo e(!empty($support->assignUser)?$support->assignUser->name:__('All')); ?>

                                </td>
                                <td>
                                    <?php if($support->priority=='low'): ?>
                                        <span
                                            class="badge badge-primary"><?php echo e(\App\Models\Support::$priority[$support->priority]); ?></span>
                                    <?php elseif($support->priority=='medium'): ?>
                                        <span
                                            class="badge badge-info"><?php echo e(\App\Models\Support::$priority[$support->priority]); ?></span>
                                    <?php elseif($support->priority=='high'): ?>
                                        <span
                                            class="badge badge-warning"><?php echo e(\App\Models\Support::$priority[$support->priority]); ?></span>
                                    <?php elseif($support->priority=='critical'): ?>
                                        <span
                                            class="badge badge-danger"><?php echo e(\App\Models\Support::$priority[$support->priority]); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($support->status=='pending'): ?>
                                        <span
                                            class="badge badge-primary"><?php echo e(\App\Models\Support::$status[$support->status]); ?></span>
                                    <?php elseif($support->status=='open'): ?>
                                        <span
                                            class="badge badge-info"><?php echo e(\App\Models\Support::$status[$support->status]); ?></span>
                                    <?php elseif($support->status=='close'): ?>
                                        <span
                                            class="badge badge-danger"><?php echo e(\App\Models\Support::$status[$support->status]); ?></span>
                                    <?php elseif($support->status=='on_hold'): ?>
                                        <span
                                            class="badge badge-warning"><?php echo e(\App\Models\Support::$status[$support->status]); ?></span>
                                    <?php endif; ?>
                                </td>
                                <?php if(Gate::check('edit support') ||  Gate::check('delete support') || Gate::check('reply support') ||  \Auth::user()->type=='super admin'): ?>
                                    <td class="text-right">
                                        <div class="cart-action">
                                            <?php echo Form::open(['method' => 'DELETE', 'route' => ['support.destroy', $support->id]]); ?>

                                            <?php if(Gate::check('reply support') ||  \Auth::user()->type=='super admin'): ?>
                                                <a class="text-secondary" data-bs-toggle="tooltip"
                                                   data-bs-original-title="<?php echo e(__('Replay')); ?>"
                                                   href="<?php echo e(route('support.show',\Crypt::encrypt($support->id))); ?>"> <i
                                                        data-feather="send"></i></a>
                                            <?php endif; ?>

                                            <?php if($support->created_id == \Auth::user()->id): ?>
                                                <?php if(Gate::check('edit support') ||  \Auth::user()->type=='super admin'): ?>
                                                    <a class="text-success customModal" data-bs-toggle="tooltip"
                                                       data-bs-original-title="<?php echo e(__('Edit')); ?>" href="#"
                                                       data-url="<?php echo e(route('support.edit',$support->id)); ?>"
                                                       data-title="<?php echo e(__('Edit Support')); ?>"> <i data-feather="edit"></i></a>
                                                <?php endif; ?>
                                                    <?php if( Gate::check('delete support') ||  \Auth::user()->type=='super admin'): ?>
                                                    <a class=" text-danger confirm_dialog" data-bs-toggle="tooltip"
                                                       data-bs-original-title="<?php echo e(__('Detete')); ?>" href="#"> <i
                                                            data-feather="trash-2"></i></a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php echo Form::close(); ?>

                                        </div>
                                    </td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Projects\FINZO\latest_template\main_file\resources\views/support/index.blade.php ENDPATH**/ ?>