<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Appointments')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <ul class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>"><h1><?php echo e(__('Dashboard')); ?></h1></a>
        </li>
        <li class="breadcrumb-item active">
            <a href="#">
                <?php echo e(__('Appointments')); ?>

            </a>
        </li>
    </ul>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('card-action-btn'); ?>
    <?php if(Gate::check('create appointment') ): ?>
        <a class="btn btn-primary btn-sm ml-20 customModal" href="#" data-size="lg"
           data-url="<?php echo e(route('appointment.create')); ?>"
           data-title="<?php echo e(__('Create Appointment')); ?>"> <i class="ti-plus mr-5"></i>
            <?php echo e(__('Create Appointment')); ?>

        </a>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table class="display dataTable cell-border datatbl-advance">
                        <thead>
                        <tr>
                            <th><?php echo e(__('Appointment')); ?></th>
                            <th><?php echo e(__('Customer')); ?></th>
                            <th><?php echo e(__('Date')); ?></th>
                            <th><?php echo e(__('Time')); ?></th>
                            <th><?php echo e(__('Category')); ?></th>
                            <th><?php echo e(__('Service')); ?></th>
                            <th><?php echo e(__('Employee')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Payment Status')); ?></th>
                            <th><?php echo e(__('Action')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td> <?php echo e(\App\Models\Custom::appointmentPrefix().$appointment->appointment_id); ?></td>
                                <td><?php echo e(!empty($appointment->customers)?$appointment->customers->name:'-'); ?> </td>
                                <td><?php echo e(\Auth::user()->dateFormat($appointment->date)); ?> </td>
                                <td><?php echo e(\Auth::user()->timeFormat($appointment->start_time).' - ' .\Auth::user()->timeFormat($appointment->end_time)); ?> </td>
                                <td><?php echo e(!empty($appointment->categories)?$appointment->categories->title:'-'); ?> </td>
                                <td><?php echo e(!empty($appointment->services)?$appointment->services->title:'-'); ?> </td>
                                <td><?php echo e(!empty($appointment->employees)?$appointment->employees->name:'-'); ?> </td>
                                <td>
                                    <?php if($appointment->status=='pending'): ?>
                                        <span class="badge badge-warning"><?php echo e(\App\Models\Appointment::$status[$appointment->status]); ?></span>
                                    <?php elseif($appointment->status=='approved'): ?>
                                        <span class="badge badge-primary"><?php echo e(\App\Models\Appointment::$status[$appointment->status]); ?></span>
                                    <?php elseif($appointment->status=='completed'): ?>
                                        <span class="badge badge-success"><?php echo e(\App\Models\Appointment::$status[$appointment->status]); ?></span>
                                    <?php elseif($appointment->status=='rejected'): ?>
                                        <span class="badge badge-danger"><?php echo e(\App\Models\Appointment::$status[$appointment->status]); ?></span>
                                    <?php elseif($appointment->status=='cancelled'): ?>
                                        <span class="badge badge-secondary"><?php echo e(\App\Models\Appointment::$status[$appointment->status]); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                <?php if($appointment->payment_status=='unpaid'): ?>
                                    <span class="badge badge-danger"><?php echo e(\App\Models\Appointment::$payment_status[$appointment->payment_status]); ?></span>
                                <?php else: ?>
                                    <span class="badge badge-success"><?php echo e(\App\Models\Appointment::$payment_status[$appointment->payment_status]); ?></span>
                                <?php endif; ?>
                                </td>
                                <td>
                                    <div class="cart-action">
                                        <?php echo Form::open(['method' => 'DELETE', 'route' => ['appointment.destroy', $appointment->id]]); ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show appointment')): ?>
                                            <a class="text-warning " data-bs-toggle="tooltip"
                                               data-bs-original-title="<?php echo e(__('Detail')); ?>" href="<?php echo e(route('appointment.show',$appointment->id)); ?>"
                                               > <i data-feather="eye"></i></a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit appointment')): ?>
                                            <a class="text-success customModal" data-bs-toggle="tooltip"
                                               data-bs-original-title="<?php echo e(__('Edit')); ?>" href="#"
                                               data-url="<?php echo e(route('appointment.edit',$appointment->id)); ?>"
                                               data-title="<?php echo e(__('Edit Appointment')); ?>" data-size="lg"> <i data-feather="edit"></i></a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete appointment')): ?>
                                            <a class=" text-danger confirm_dialog" data-bs-toggle="tooltip"
                                               data-bs-original-title="<?php echo e(__('Detete')); ?>" href="#"> <i
                                                    data-feather="trash-2"></i></a>
                                        <?php endif; ?>
                                        <?php echo Form::close(); ?>

                                    </div>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Projects\FINZO\latest_template\main_file\resources\views/appointment/index.blade.php ENDPATH**/ ?>