<?php
    $profile=asset(Storage::url('upload/profile/'));
?>
<?php $__env->startSection('page-title'); ?>
    <?php if(\Auth::user()->type=='super admin'): ?>
        <?php echo e(__('Owners')); ?>

    <?php else: ?>
        <?php echo e(__('Users')); ?>

    <?php endif; ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <ul class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>"><h1><?php echo e(__('Dashboard')); ?></h1></a>
        </li>
        <li class="breadcrumb-item active">
            <a href="#">
                <?php if(\Auth::user()->type=='super admin'): ?>
                    <?php echo e(__('Owners')); ?>

                <?php else: ?>
                    <?php echo e(__('Users')); ?>

                <?php endif; ?>

            </a>
        </li>
    </ul>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('card-action-btn'); ?>
    <?php if(Gate::check('manage user') || \Auth::user()->type=='super admin'): ?>
        <a class="btn btn-primary btn-sm ml-20 customModal" href="#" data-size="md"
           data-url="<?php echo e(route('users.create')); ?>"
           data-title="<?php echo e((\Auth::user()->type=='super admin')?__('Create Owner'):__('Create User')); ?>"> <i
                class="ti-plus mr-5"></i>
            <?php if(\Auth::user()->type=='super admin'): ?>
                <?php echo e(__('Create Owner')); ?>

            <?php else: ?>
                <?php echo e(__('Create User')); ?>

            <?php endif; ?>
        </a>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <?php if(\Auth::user()->type=='super admin'): ?>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-3 col-lg-4 col-sm-6 cdx-xxl-33 cdx-xl-33">
                    <div class="card user-card">
                        <div class="card-header">
                            <div class="user-setting">
                                <div class="action-menu">
                                    <div class="action-toggle"><i data-feather="more-vertical"> </i></div>
                                    <ul class="action-dropdown">
                                        <li><a href="#" class="customModal"
                                               data-url="<?php echo e(route('users.edit',$user->id)); ?>"
                                               data-title="<?php echo e(__('Edit User')); ?>"> <i
                                                    data-feather="edit"></i><?php echo e(__('Edit User')); ?></a></li>
                                        <li>
                                            <?php echo Form::open(['method' => 'DELETE', 'route' => ['users.destroy', $user->id]]); ?>

                                            <a href="#" class="confirm_dialog"> <i
                                                    data-feather="trash"></i><?php echo e(__('Delete User')); ?></a>
                                            <?php echo Form::close(); ?>

                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="user-imgwrap">
                                <img class="img-fluid rounded-50"
                                     src="<?php echo e((!empty($user->avatar))? asset(Storage::url("upload/profile/".$user->avatar)): asset(Storage::url("upload/profile/avatar.png"))); ?>"
                                     alt="<?php echo e($user->name); ?>"></div>
                            <div class="user-detailwrap">
                                <h3><?php echo e($user->name); ?></h3>
                                <h6><?php echo e($user->type); ?></h6>
                                <p> <?php echo e($user->email); ?></p>
                                <p class="mt-5"> <?php echo e(__('Subscription Expired : ')); ?> <?php echo e(!empty($user->plan_expire_date) ? \Auth::user()->dateFormat($user->plan_expire_date): __('Unlimited')); ?></p>
                                <div class="group-btn">
                                    <span class="btn btn-primary btn-md"> <?php echo e(__('User')); ?> : <?php echo e($user->totalUser()); ?></span>
                                    <span class="btn btn-secondary btn-md"> <?php echo e(__('Appointment')); ?> : <?php echo e($user->totalAppointment()); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <table class="display dataTable cell-border datatbl-advance">
                            <thead>
                            <tr>
                                <th><?php echo e(__('User')); ?></th>
                                <th><?php echo e(__('Email')); ?></th>
                                <th><?php echo e(__('Phone Number')); ?></th>
                                <th><?php echo e(__('Role')); ?></th>
                                <th><?php echo e(__('Action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="table-user">
                                        <img
                                            src="<?php echo e(!empty($user->avatar)?asset(Storage::url('upload/profile')).'/'.$user->avatar:asset(Storage::url('upload/profile')).'/avatar.png'); ?>"
                                            alt="" class="mr-2 avatar-sm rounded-circle user-avatar">
                                        <a href="#" class="text-body font-weight-semibold"><?php echo e($user->name); ?></a>
                                    </td>
                                    <td><?php echo e($user->email); ?> </td>
                                    <td><?php echo e(!empty($user->phone_number)?$user->phone_number:'-'); ?> </td>
                                    <td><?php echo e(ucfirst($user->type)); ?> </td>
                                    <td>
                                        <div class="cart-action">
                                            <?php echo Form::open(['method' => 'DELETE', 'route' => ['users.destroy', $user->id]]); ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit user')): ?>
                                                <a class="text-success customModal" data-bs-toggle="tooltip"
                                                   data-bs-original-title="<?php echo e(__('Edit')); ?>" href="#"
                                                   data-url="<?php echo e(route('users.edit',$user->id)); ?>"
                                                   data-title="<?php echo e(__('Edit Customer')); ?>"> <i data-feather="edit"></i></a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete user')): ?>
                                                <a class=" text-danger confirm_dialog" data-bs-toggle="tooltip"
                                                   data-bs-original-title="<?php echo e(__('Detete')); ?>" href="#"> <i
                                                        data-feather="trash-2"></i></a>
                                            <?php endif; ?>
                                            <?php echo Form::close(); ?>

                                        </div>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Projects\FINZO\latest_template\main_file\resources\views/user/index.blade.php ENDPATH**/ ?>