<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Packages')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <ul class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>"><h1><?php echo e(__('Dashboard')); ?></h1></a>
        </li>
        <li class="breadcrumb-item active">
            <a href="#"><?php echo e(__('Packages')); ?></a>
        </li>
    </ul>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('card-action-btn'); ?>
    <?php if(\Auth::user()->type=='super admin' &&  (env('STRIPE_PAYMENT') == 'on' )): ?>
        <a class="btn btn-primary btn-sm ml-20 customModal" href="#" data-size="md"
           data-url="<?php echo e(route('subscriptions.create')); ?>"
           data-title="<?php echo e(__('Create Package')); ?>"> <i class="ti-plus mr-5"></i><?php echo e(__('Create Package')); ?></a>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row pricing-grid">
        <?php $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-xxl-3 cdx-xl-50 col-sm-6">
                <div class="codex-pricingtbl">
                    <div class="price-header">
                        <h2><?php echo e($subscription->name); ?></h2>
                        <div class="price-value"><?php echo e(env('CURRENCY_SYMBOL').$subscription->price); ?>

                            <span>/ <?php echo e($subscription->duration); ?></span></div>
                    </div>
                    <ul class="cdxprice-list">
                        <li><span><?php echo e($subscription->total_user); ?></span><?php echo e(__('User Limit')); ?></li>
                        <li><span><?php echo e($subscription->total_appointment); ?></span><?php echo e(__('Appointment Limit')); ?></li>
                        <li><span><?php echo e($subscription->total_service); ?></span><?php echo e(__('Service Limit')); ?></li>

                        <li>
                            <div class="delet-mail">
                                <?php if($subscription->enabled_logged_history==1): ?>
                                    <i class="text-success mr-4" data-feather="check-circle"></i>
                                <?php else: ?>
                                    <i class="text-danger mr-4" data-feather="x-circle"></i>
                                <?php endif; ?>
                                <?php echo e(__('User Logged History')); ?>

                            </div>
                        </li>
                        <?php if(\Auth::user()->type!='super admin' && \Auth::user()->subscription == $subscription->id): ?>
                        <li>
                            <span><?php echo e(\Auth::user()->subscription_expire_date ? \Auth::user()->dateFormat(\Auth::user()->subscription_expire_date):__('Unlimited')); ?></span><?php echo e(__('Expiry Date')); ?>

                        </li>
                            <?php endif; ?>
                    </ul>
                    <?php if(\Auth::user()->type=='admin' && \Auth::user()->subscription == $subscription->id): ?>
                        <a href="#" class="badge badge-success"><?php echo e(__('Active')); ?></a>
                    <?php endif; ?>
                    <?php if(\Auth::user()->type=='admin' && \Auth::user()->subscription != $subscription->id): ?>
                        <a class="text-success" data-bs-toggle="tooltip" data-bs-original-title="<?php echo e(__('Detail')); ?>"
                           href="<?php echo e(route('subscriptions.show',\Illuminate\Support\Facades\Crypt::encrypt($subscription->id))); ?>"><i data-feather="shopping-cart"></i></a>
                    <?php endif; ?>
                    <?php if(\Auth::user()->type=='super admin'): ?>
                        <?php echo Form::open(['method' => 'DELETE', 'route' => ['subscriptions.destroy', $subscription->id]]); ?>

                        <div class="date-info">
                            <a class="text-success customModal" data-bs-toggle="tooltip"
                               data-bs-original-title="<?php echo e(__('Edit')); ?>" href="#"
                               data-url="<?php echo e(route('subscriptions.edit',$subscription->id)); ?>"
                               data-title="<?php echo e(__('Edit Package')); ?>"> <i data-feather="edit"></i></a>
                            <a class=" text-danger confirm_dialog" data-bs-toggle="tooltip"
                               data-bs-original-title="<?php echo e(__('Detete')); ?>" href="#"> <i data-feather="trash-2"></i></a>
                        </div>
                        <?php echo Form::close(); ?>

                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Projects\FINZO\latest_template\main_file\resources\views/subscription/index.blade.php ENDPATH**/ ?>