<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Payment Settings')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <ul class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>"><h1><?php echo e(__('Dashboard')); ?></h1></a>
        </li>
        <li class="breadcrumb-item active">
            <a href="#"><?php echo e(__('Payment Settings')); ?></a>
        </li>
    </ul>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <?php echo e(Form::model($loginUser, array('route' => array('setting.payment'), 'method' => 'post'))); ?>

                    <div class="row">
                        <div class="form-group col-md-6">
                            <?php echo e(Form::label('currency',__('Currency'),array('class'=>'form-label'))); ?>

                            <?php echo e(Form::text('currency',env('CURRENCY'),array('class'=>'form-control font-style','placeholder'=>__('Enter currency'),'required'))); ?>

                        </div>
                        <div class="form-group col-md-6">
                            <?php echo e(Form::label('currency_symbol',__('Currency Symbol'),array('class'=>'form-label'))); ?>

                            <?php echo e(Form::text('currency_symbol',env('CURRENCY_SYMBOL'),array('class'=>'form-control','placeholder'=>__('Enter currency symbol'),'required'))); ?>

                        </div>

                    </div>

                    <div class="row mt-2">
                        <div class="col-auto">
                            <?php echo e(Form::label('stripe_payment',__('Stripe Payment'),array('class'=>'form-label'))); ?>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <div class="form-check custom-chek">
                                    <input class="form-check-input" type="checkbox" name="stripe_payment" id="stripe_payment" <?php echo e(env('STRIPE_PAYMENT') == 'on' ? 'checked' : ''); ?>>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-6">
                            <?php echo e(Form::label('stripe_key',__('Stripe Key'),array('class'=>'form-label'))); ?>

                            <?php echo e(Form::text('stripe_key',env('STRIPE_KEY'),['class'=>'form-control','placeholder'=>__('Enter stripe key')])); ?>

                        </div>
                        <div class="form-group col-md-6">
                            <?php echo e(Form::label('stripe_secret',__('Stripe Secret'),array('class'=>'form-label'))); ?>

                            <?php echo e(Form::text('stripe_secret',env('STRIPE_SECRET'),['class'=>'form-control ','placeholder'=>__('Enter stripe secret')])); ?>

                        </div>
                    </div>
                    <div class="text-right">
                        <?php echo e(Form::submit(__('Save'),array('class'=>'btn btn-primary btn-rounded'))); ?>

                    </div>
                    <?php echo e(Form::close()); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Projects\FINZO\latest_template\main_file\resources\views/settings/payment.blade.php ENDPATH**/ ?>