<?php echo e(Form::open(array('url'=>'users','method'=>'post'))); ?>

<div class="modal-body">
    <div class="row">
        <div class="col-md-12">
            <div class="form-group">
                <?php echo e(Form::label('name',__('Name'),array('class'=>'form-label'))); ?>

                <?php echo e(Form::text('name',null,array('class'=>'form-control','placeholder'=>__('Enter Name'),'required'=>'required'))); ?>

            </div>
        </div>
        <div class="col-md-12">
            <div class="form-group">
                <?php echo e(Form::label('email',__('Email'),array('class'=>'form-label'))); ?>

                <?php echo e(Form::text('email',null,array('class'=>'form-control','placeholder'=>__('Enter Email'),'required'=>'required'))); ?>


            </div>
        </div>
        <div class="col-md-12">
            <div class="form-group">
                <?php echo e(Form::label('password',__('Password'),array('class'=>'form-label'))); ?>

                <?php echo e(Form::password('password',array('class'=>'form-control','placeholder'=>__('Enter Password'),'required'=>'required','minlength'=>"6"))); ?>


            </div>
        </div>
        <div class="col-md-12">
            <div class="form-group">
                <?php echo e(Form::label('phone_number',__('Phone Number'),array('class'=>'form-label'))); ?>

                <?php echo e(Form::text('phone_number',null,array('class'=>'form-control','placeholder'=>__('Enter Phone Number'),'required'=>'required'))); ?>

            </div>
        </div>
        <?php if(\Auth::user()->type != 'super admin'): ?>
            <div class="form-group col-md-12">
                <?php echo e(Form::label('role', __('User Role'),['class'=>'form-label'])); ?>

                <?php echo Form::select('role', $roles, null,array('class' => 'form-control hidesearch','required'=>'required')); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<div class="modal-footer">
    <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
    <?php echo e(Form::submit(__('Create'),array('class'=>'btn btn-primary ml-10'))); ?>

</div>
<?php echo e(Form::close()); ?>


<?php /**PATH D:\Projects\FINZO\latest_template\main_file\resources\views/user/create.blade.php ENDPATH**/ ?>