<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Note')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <ul class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>"><h1><?php echo e(__('Dashboard')); ?></h1></a>
        </li>
        <li class="breadcrumb-item active">
            <a href="#"><?php echo e(__('Note')); ?></a>
        </li>
    </ul>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('card-action-btn'); ?>
    <?php if(Gate::check('create note') || \Auth::user()->type=='super admin'): ?>
        <a class="btn btn-primary btn-sm ml-20 customModal" href="#" data-size="md"
           data-url="<?php echo e(route('note.create')); ?>"
           data-title="<?php echo e(__('Create Note')); ?>"> <i class="ti-plus mr-5"></i><?php echo e(__('Create Note')); ?></a>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <?php $__currentLoopData = $notes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-xl-4 col-sm-6 cdx-xl-50">
                <div class="card blog-wrapper">
                    <div class="detailwrapper">
                        <a href="#">
                            <h4><?php echo e($note->title); ?></h4>
                        </a>
                        <ul class="blogsoc-list">
                            <li><a href="#"><i
                                        data-feather="calendar"></i><?php echo e(\Auth::user()->dateFormat($note->created_at)); ?></a>
                            </li>
                            <li><a href="<?php echo e(asset('/storage/upload/applicant/attachment/'.$note->attachment)); ?>"
                                   target="_blank"><i data-feather="download"></i><?php echo e(__('Attachment')); ?></a></li>
                        </ul>
                        <p><?php echo e($note->description); ?></p>
                        <?php if(Gate::check('edit notes') || Gate::check('delete notes') || \Auth::user()->type=='super admin'): ?>
                            <div class="blog-footer">
                                <?php echo Form::open(['method' => 'DELETE', 'route' => ['note.destroy', $note->id]]); ?>

                                <div class="date-info">
                                    <?php if(Gate::check('edit note') || \Auth::user()->type=='super admin'): ?>
                                        <a class="text-success customModal" data-bs-toggle="tooltip"
                                           data-bs-original-title="<?php echo e(__('Edit')); ?>" href="#"
                                           data-url="<?php echo e(route('note.edit',$note->id)); ?>"
                                           data-title="<?php echo e(__('Edit Note')); ?>">
                                            <i data-feather="edit"></i></a>
                                    <?php endif; ?>
                                    <?php if(Gate::check('delete note') || \Auth::user()->type=='super admin'): ?>
                                        <a class=" text-danger confirm_dialog" data-bs-toggle="tooltip"
                                           data-bs-original-title="<?php echo e(__('Detete')); ?>" href="#"> <i
                                                data-feather="trash-2"></i></a>
                                    <?php endif; ?>
                                </div>
                                <?php echo Form::close(); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Projects\FINZO\latest_template\main_file\resources\views/note/index.blade.php ENDPATH**/ ?>