@extends('layouts.app')
@section('page-title')
    {{__('Services')}}
@endsection
@section('breadcrumb')
    <ul class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{route('dashboard')}}"><h1>{{__('Dashboard')}}</h1></a>
        </li>
        <li class="breadcrumb-item active">
            <a href="#">{{__('Services')}}</a>
        </li>
    </ul>
@endsection
@section('card-action-btn')
    @if(Gate::check('create service'))
        <a class="btn btn-primary btn-sm ml-20 customModal" href="#" data-size="md"
           data-url="{{ route('services.create') }}"
           data-title="{{__('Create Service')}}"> <i class="ti-plus mr-5"></i>{{__('Create Service')}}</a>
    @endif
@endsection
@section('content')

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table class="display dataTable cell-border datatbl-advance">
                        <thead>
                        <tr>
                            <th>{{__('Title')}}</th>
                            <th>{{__('Fees')}}</th>
                            <th>{{__('Category')}}</th>
                            <th>{{__('Duration')}}</th>
                            <th>{{__('Description')}}</th>
                            @if(Gate::check('edit service') ||  Gate::check('delete service'))
                                <th class="text-right">{{__('Action')}}</th>
                            @endif
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($services as $service)
                            <tr role="row">
                                <td>
                                    {{ $service->title }}
                                </td>
                                <td>
                                    {{ \Auth::user()->priceFormat($service->fees) }}
                                </td>
                                <td>
                                    {{ !empty($service->categories)?$service->categories->title:'-' }}
                                </td>
                                <td>
                                    {{$service->duration }}
                                </td>
                                <td>
                                    {{ $service->description }}
                                </td>
                                @if(Gate::check('edit service') ||  Gate::check('delete service'))
                                    <td class="text-right">
                                        <div class="cart-action">
                                            {!! Form::open(['method' => 'DELETE', 'route' => ['services.destroy', $service->id]]) !!}

                                            @if(Gate::check('edit service') )
                                                <a class="text-success customModal" data-bs-toggle="tooltip"
                                                   data-bs-original-title="{{__('Edit')}}" href="#"
                                                   data-url="{{ route('services.edit',$service->id) }}"
                                                   data-title="{{__('Edit Service')}}"> <i data-feather="edit"></i></a>
                                            @endcan
                                            @if( Gate::check('delete service'))
                                                <a class=" text-danger confirm_dialog" data-bs-toggle="tooltip"
                                                   data-bs-original-title="{{__('Detete')}}" href="#"> <i
                                                        data-feather="trash-2"></i></a>
                                            @endcan
                                            {!! Form::close() !!}
                                        </div>
                                    </td>
                                @endif
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

