@extends('layouts.app')
@php
    $admin_logo=\App\Models\Custom::getValByName('company_logo');
    $settings=\App\Models\Custom::settings();
@endphp
@section('page-title')
    {{__('Appointment Details')}}
@endsection
@push('script-page')
    <script>
        $(document).on('click', '.print', function () {
            var printContents = document.getElementById('invoice-print').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

        });
    </script>
@endpush
@section('breadcrumb')
    <ul class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{route('dashboard')}}"><h1>{{__('Dashboard')}}</h1></a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{route('appointment.index')}}">{{__('Appointment')}}</a>
        </li>
        <li class="breadcrumb-item active">
            <a href="#">{{__('Detail')}}</a>
        </li>
    </ul>

@endsection

@section('content')
    <div class="row mb-10">
        <div class="col-12">
            <div class="invoice-action text-end">
                <a class="btn btn-secondary print" href="javascript:void(0);"> {{__('Print Invoice')}}</a>
                @if(Gate::check('manage appointment') )
                <a class="btn btn-primary ml-15 customModal" href="javascript:void(0);"  data-url="{{ route('appointment.payment.create',$appointment->id) }}"
                   data-title="{{__('Add Payment')}}">{{__('Add Payment')}}</a></div>
            @endif
        </div>
    </div>
    <div class="row" id="invoice-print">
        <div class="col-12">
            <div class="card">
                <div class="card-body cdx-invoice">

                    <div id="cdx-invoice">
                        <div class="head-invoice">
                            <div class="codex-brand">
                                <a class="codexbrand-logo" href="Javascript:void(0);">
                                    <img class="img-fluid invoice-logo"
                                         src=" {{asset(Storage::url('upload/logo/')).'/'.(isset($admin_logo) && !empty($admin_logo)?$admin_logo:'logo.png')}}"
                                         alt="invoice-logo">
                                </a>
                                <a class="codexdark-logo" href="Javascript:void(0);">
                                    <img class="img-fluid invoice-logo"
                                         src=" {{asset(Storage::url('upload/logo/')).'/'.(isset($admin_logo) && !empty($admin_logo)?$admin_logo:'logo.png')}}"
                                         alt="invoice-logo">
                                </a>
                            </div>
                            <ul class="contact-list">
                                <li>
                                    <div class="icon-wrap"><i class="fa fa-user"></i></div>{{$settings['company_name']}}
                                </li>
                                <li>
                                    <div class="icon-wrap"><i class="fa fa-phone"></i>
                                    </div>{{$settings['company_phone']}}
                                </li>
                                <li>
                                    <div class="icon-wrap"><i class="fa fa-envelope"></i>
                                    </div>{{$settings['company_email']}}
                                </li>
                            </ul>
                        </div>
                        <div class="invoice-user">
                            <div class="left-user">
                                <h5>{{__('To')}}:</h5>
                                <ul class="detail-list">
                                    <li>
                                        <div class="icon-wrap"><i class="fa fa-user"></i>
                                        </div>{{!empty($appointment) && !empty($appointment->customers)?$appointment->customers->name:''}}
                                    </li>
                                    <li>
                                        <div class="icon-wrap"><i class="fa fa-phone"></i>
                                        </div>{{!empty($appointment) && !empty($appointment->customers) ?$appointment->customers->phone_number:'-'}}
                                    </li>
                                    <li>
                                        <div class="icon-wrap"><i class="fa fa-envelope"></i></div>
                                        {{!empty($appointment) && !empty($appointment->customers)?$appointment->customers->email:''}}
                                    </li>
                                </ul>
                            </div>
                            <div class="right-user">
                                <ul class="detail-list">

                                    <li>{{__('Appointment No')}}:
                                        <span>{{\App\Models\Custom::appointmentPrefix().$appointment->appointment_id}} </span>
                                    </li>
                                    <li>{{__('Appointment Date')}}:
                                        <span> {{ \Auth::user()->dateFormat($appointment->date) }}  </span></li>
                                    <li>{{__('Created Date')}}:
                                        <span> {{ \Auth::user()->dateFormat($appointment->created_at) }}  </span></li>
                                    <li>{{__('Employee')}}:
                                        <span>{{ !empty($appointment->employees)?$appointment->employees->name:'-' }} </span>
                                    </li>
                                    <li>{{__('Payment Status')}}:
                                        @if($appointment->payment_status=='unpaid')
                                            <span class="badge badge-danger">{{\App\Models\Appointment::$payment_status[$appointment->payment_status]}}</span>
                                        @else
                                            <span class="badge badge-success">{{\App\Models\Appointment::$payment_status[$appointment->payment_status]}}</span>
                                        @endif
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="body-invoice">
                            <div class="table-responsive1">
                                <table class="table ml-1">
                                    <thead>
                                    <tr>
                                        <th>{{__('Category')}}</th>
                                        <th>{{__('Service')}}</th>
                                        <th>{{__('Start Time')}}</th>
                                        <th>{{__('End Time')}}</th>
                                        <th>{{__('Status')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>{{ !empty($appointment->categories)?$appointment->categories->title:'-' }} </td>
                                        <td>{{ !empty($appointment->services)?$appointment->services->title:'-' }}</td>
                                        <td>{{ \Auth::user()->timeFormat($appointment->start_time) }}</td>
                                        <td>{{ \Auth::user()->timeFormat($appointment->end_time) }}</td>
                                        <td>
                                            @if($appointment->status=='pending')
                                                <span
                                                    class="badge badge-warning">{{\App\Models\Appointment::$status[$appointment->status]}}</span>
                                            @elseif($appointment->status=='approved')
                                                <span
                                                    class="badge badge-primary">{{\App\Models\Appointment::$status[$appointment->status]}}</span>
                                            @elseif($appointment->status=='completed')
                                                <span
                                                    class="badge badge-success">{{\App\Models\Appointment::$status[$appointment->status]}}</span>
                                            @elseif($appointment->status=='rejected')
                                                <span
                                                    class="badge badge-danger">{{\App\Models\Appointment::$status[$appointment->status]}}</span>
                                            @elseif($appointment->status=='cancelled')
                                                <span
                                                    class="badge badge-secondary">{{\App\Models\Appointment::$status[$appointment->status]}}</span>
                                            @endif
                                        </td>
                                    </tr>

                                    </tbody>
                                </table>
                            </div>
                            @if(!empty($appointment->payment_date))
                            <div class="table-responsive1 mt-20">
                                <table class="table ml-1">
                                    <thead>
                                    <tr>
                                        <th>{{__('Payment Date')}}</th>
                                        <th>{{__('Payment Method')}}</th>
                                        <th>{{__('Amount')}}</th>
                                        <th>{{__('Detail')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>{{\Auth::user()->dateFormat($appointment->payment_date) }} </td>
                                        <td>{{ \App\Models\Appointment::$payment_method[$appointment->payment_method]}}</td>
                                        <td>{{ \Auth::user()->priceFormat($appointment->amount) }}</td>
                                        <td>{{ $appointment->payment_details}}</td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            @endif

                        </div>
                        <div class="notes mt-15">
                            <b>{{__('Notes')}} :</b> {{$appointment->notes}}
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection
