@extends('layouts.app')

@section('page-title')
    {{__('Appointments')}}
@endsection
@section('breadcrumb')
    <ul class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{route('dashboard')}}"><h1>{{__('Dashboard')}}</h1></a>
        </li>
        <li class="breadcrumb-item active">
            <a href="#">
                {{__('Appointments')}}
            </a>
        </li>
    </ul>
@endsection
@section('card-action-btn')
    @if(Gate::check('create appointment') )
        <a class="btn btn-primary btn-sm ml-20 customModal" href="#" data-size="lg"
           data-url="{{ route('appointment.create') }}"
           data-title="{{__('Create Appointment')}}"> <i class="ti-plus mr-5"></i>
            {{__('Create Appointment')}}
        </a>
    @endif
@endsection
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table class="display dataTable cell-border datatbl-advance">
                        <thead>
                        <tr>
                            <th>{{__('Appointment')}}</th>
                            <th>{{__('Customer')}}</th>
                            <th>{{__('Date')}}</th>
                            <th>{{__('Time')}}</th>
                            <th>{{__('Category')}}</th>
                            <th>{{__('Service')}}</th>
                            <th>{{__('Employee')}}</th>
                            <th>{{__('Status')}}</th>
                            <th>{{__('Payment Status')}}</th>
                            <th>{{__('Action')}}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($appointments as $appointment)
                            <tr>
                                <td> {{\App\Models\Custom::appointmentPrefix().$appointment->appointment_id}}</td>
                                <td>{{ !empty($appointment->customers)?$appointment->customers->name:'-' }} </td>
                                <td>{{ \Auth::user()->dateFormat($appointment->date) }} </td>
                                <td>{{ \Auth::user()->timeFormat($appointment->start_time).' - ' .\Auth::user()->timeFormat($appointment->end_time) }} </td>
                                <td>{{ !empty($appointment->categories)?$appointment->categories->title:'-' }} </td>
                                <td>{{ !empty($appointment->services)?$appointment->services->title:'-' }} </td>
                                <td>{{ !empty($appointment->employees)?$appointment->employees->name:'-' }} </td>
                                <td>
                                    @if($appointment->status=='pending')
                                        <span class="badge badge-warning">{{\App\Models\Appointment::$status[$appointment->status]}}</span>
                                    @elseif($appointment->status=='approved')
                                        <span class="badge badge-primary">{{\App\Models\Appointment::$status[$appointment->status]}}</span>
                                    @elseif($appointment->status=='completed')
                                        <span class="badge badge-success">{{\App\Models\Appointment::$status[$appointment->status]}}</span>
                                    @elseif($appointment->status=='rejected')
                                        <span class="badge badge-danger">{{\App\Models\Appointment::$status[$appointment->status]}}</span>
                                    @elseif($appointment->status=='cancelled')
                                        <span class="badge badge-secondary">{{\App\Models\Appointment::$status[$appointment->status]}}</span>
                                    @endif
                                </td>
                                <td>
                                @if($appointment->payment_status=='unpaid')
                                    <span class="badge badge-danger">{{\App\Models\Appointment::$payment_status[$appointment->payment_status]}}</span>
                                @else
                                    <span class="badge badge-success">{{\App\Models\Appointment::$payment_status[$appointment->payment_status]}}</span>
                                @endif
                                </td>
                                <td>
                                    <div class="cart-action">
                                        {!! Form::open(['method' => 'DELETE', 'route' => ['appointment.destroy', $appointment->id]]) !!}
                                        @can('show appointment')
                                            <a class="text-warning " data-bs-toggle="tooltip"
                                               data-bs-original-title="{{__('Detail')}}" href="{{ route('appointment.show',$appointment->id) }}"
                                               > <i data-feather="eye"></i></a>
                                        @endcan
                                        @can('edit appointment')
                                            <a class="text-success customModal" data-bs-toggle="tooltip"
                                               data-bs-original-title="{{__('Edit')}}" href="#"
                                               data-url="{{ route('appointment.edit',$appointment->id) }}"
                                               data-title="{{__('Edit Appointment')}}" data-size="lg"> <i data-feather="edit"></i></a>
                                        @endcan
                                        @can('delete appointment')
                                            <a class=" text-danger confirm_dialog" data-bs-toggle="tooltip"
                                               data-bs-original-title="{{__('Detete')}}" href="#"> <i
                                                    data-feather="trash-2"></i></a>
                                        @endcan
                                        {!! Form::close() !!}
                                    </div>

                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
