{{ Form::model($appointment, array('route' => array('appointment.update', $appointment->id), 'method' => 'PUT')) }}
<div class="modal-body">
    <div class="row">
        <div class="col-md-6">
            <div class="form-group">
                {{ Form::label('user_id', __('Employee'),['class'=>'form-label']) }}
                {!! Form::select('user_id', $employees, null,array('class' => 'form-control hidesearch','required'=>'required')) !!}
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                {{ Form::label('customer_id', __('Customer'),['class'=>'form-label']) }}
                {!! Form::select('customer_id', $customers, null,array('class' => 'form-control hidesearch','required'=>'required')) !!}
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                {{ Form::label('category', __('Category'),['class'=>'form-label']) }}
                {!! Form::select('category', $category, null,array('class' => 'form-control hidesearch','id'=>'category_id','required'=>'required')) !!}
            </div>
        </div>
        <div class="form-group col-lg-6 col-md-6">
            {{Form::label('service',__('Service'),array('class'=>'form-label'))}}
            <div class="service_div">
                <select class="form-control hidesearch service" id="service" name="service">
                    <option value="">{{__('Select service')}}</option>
                </select>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                {{ Form::label('status', __('Status'),['class'=>'form-label']) }}
                {!! Form::select('status', $status, null,array('class' => 'form-control hidesearch','required'=>'required')) !!}
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                {{Form::label('date',__('Date'),array('class'=>'form-label')) }}
                {{Form::date('date',null,array('class'=>'form-control','required'=>'required'))}}
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                {{Form::label('start_time',__('Start Time'),array('class'=>'form-label')) }}
                {{Form::time('start_time',null,array('class'=>'form-control','required'=>'required'))}}
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                {{Form::label('end_time',__('End Time'),array('class'=>'form-label')) }}
                {{Form::time('end_time',null,array('class'=>'form-control','required'=>'required'))}}
            </div>
        </div>
        <div class="form-group  col-md-12">
            {{Form::label('notes',__('Notes'),array('class'=>'form-label'))}}
            {{Form::textarea('notes',null,array('class'=>'form-control','rows'=>2))}}
        </div>
    </div>
</div>
<div class="modal-footer">
    <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">{{__('Close')}}</button>
    {{Form::submit(__('Update'),array('class'=>'btn btn-primary ml-10'))}}
</div>
{{Form::close()}}

<script>
    $('#category_id').on('change', function () {
        "use strict";
        var category_id=$(this).val();
        var url = '{{ route("category.services", ":id") }}';
        url = url.replace(':id', category_id);
        $.ajax({
            url: url,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: {
                category_id:category_id,
            },
            contentType: false,
            processData: false,
            type: 'GET',
            success: function (data) {
                $('.service').empty();
                var service = `<select class="form-control hidesearch service" id="service" name="service"></select>`;
                $('.service_div').html(service);

                $.each(data, function(key, value) {
                    $('.service').append('<option value="' + key + '">' + value +'</option>');
                });
                $('.hidesearch').select2({
                    minimumResultsForSearch: -1
                });
            },

        });
    });

    $('#category_id').trigger('change');
</script>
