@extends('layouts.app')
@section('page-title')
    {{__('Calendar')}}
@endsection
@section('breadcrumb')
    <ul class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{route('dashboard')}}"><h1>{{__('Dashboard')}}</h1></a>
        </li>
        <li class="breadcrumb-item active">
            <a href="#">
                {{__('Calendar')}}
            </a>
        </li>
    </ul>
@endsection
@push('css-page')
    <link href="{{ asset('assets/css/vendor/calendar/calendar.css') }}" rel="stylesheet">
@endpush
@push('script-page')

    <script>
        var eventData={!! json_encode($eventData) !!};

    </script>
    <script src="{{ asset('assets/js/vendors/calendar/calendar.js') }}"></script>
    <script src="{{ asset('assets/js/vendors/calendar/custom-calendar.js') }}"></script>
@endpush
@section('page-class')
    codex-calendar
@endsection
@section('card-action-btn')
    @if(Gate::check('create appointment') )
        <a class="btn btn-primary btn-sm ml-20 customModal" href="#" data-size="lg"
           data-url="{{ route('appointment.create') }}"
           data-title="{{__('Create Appointment')}}"> <i class="ti-plus mr-5"></i>
            {{__('Create Appointment')}}
        </a>
    @endif
@endsection
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class=" col-xxl-3">
                            <ul class="events-list" id="codex-events-list">
                                @foreach($currentMonth as $appo)
                                <li class="fc-event bg-primary">
                                    <i class="fa fa-user"></i>
                                    {{$appo['title']}}
                                    <br >
                                    <i class="fa fa-calendar mt-5"></i>
                                    <small>{{$appo['date']}} {{$appo['time']}}</small>
                                </li>

                                @endforeach
                            </ul>
                        </div>
                        <div class=" col-xxl-9">
                            <div id="codex-calendar"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="e-modal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5><span class="close-modal" data-bs-dismiss="modal">            <i
                            class="ti-close"></i></span>
                </div>
                <div class="modal-body">
                    <form class="needs-validation" id="form-event" name="e-form" novalidate=""> </form>
                </div>
            </div>
        </div>
    </div>
@endsection
