<?php
namespace Database\Seeders;
use App\Models\EmployeeDetail;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class UsersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $arrPermissions = [
            'manage user',
            'create user',
            'edit user',
            'delete user',
            'manage role',
            'create role',
            'edit role',
            'delete role',
            'manage contact',
            'create contact',
            'edit contact',
            'delete contact',
            'manage support',
            'create support',
            'edit support',
            'delete support',
            'reply support',
            'manage note',
            'create note',
            'edit note',
            'delete note',
            'manage category',
            'create category',
            'edit category',
            'delete category',
            'manage logged history',
            'manage service',
            'create service',
            'edit service',
            'delete service',
            'manage customer',
            'create customer',
            'edit customer',
            'delete customer',
            'manage employee',
            'create employee',
            'edit employee',
            'delete employee',
            'manage appointment',
            'create appointment',
            'edit appointment',
            'delete appointment',
            'show appointment',
            'create payment',
            'manage account settings',
            'manage password settings',
            'manage general settings',
            'manage company settings',
        ];
        foreach($arrPermissions as $ap)
        {
            Permission::create(['name' => $ap]);
        }


        // Default Super admin
        $superAdmin = User::create(
            [
                'name' => 'Super Admin',
                'email' => 'superadmin@gmail.com',
                'password' => Hash::make('123456'),
                'type' => 'super admin',
                'lang' => 'english',
                'profile' => 'avatar.png',
                'parent_id' => 0,
            ]
        );

        // Default admin role
        $adminRole = Role::create(
            [
                'name' => 'owner',
                'parent_id' => $superAdmin->id,
            ]
        );
        // Default admin permissions
        $adminPermissions = [
            'manage user',
            'create user',
            'edit user',
            'delete user',
            'manage role',
            'create role',
            'edit role',
            'delete role',
            'manage contact',
            'create contact',
            'edit contact',
            'delete contact',
            'manage support',
            'create support',
            'edit support',
            'delete support',
            'reply support',
            'manage note',
            'create note',
            'edit note',
            'delete note',
            'manage category',
            'create category',
            'edit category',
            'delete category',
            'manage logged history',
            'manage service',
            'create service',
            'edit service',
            'delete service',
            'manage customer',
            'create customer',
            'edit customer',
            'delete customer',
            'manage employee',
            'create employee',
            'edit employee',
            'delete employee',
            'manage appointment',
            'create appointment',
            'edit appointment',
            'delete appointment',
            'show appointment',
            'create payment',
            'manage account settings',
            'manage password settings',
            'manage general settings',
            'manage company settings',
        ];
        foreach($adminPermissions as $ap)
        {
            $permission = Permission::findByName($ap);
            $adminRole->givePermissionTo($permission);
        }
        // Default admin
        $admin = User::create(
            [
                'name' => 'Owner',
                'email' => 'owner@gmail.com',
                'password' => Hash::make('123456'),
                'type' => 'admin',
                'lang' => 'english',
                'profile' => 'avatar.png',
                'subscription' => 1,
                'parent_id' => $superAdmin->id,
            ]
        );
        // Default admin role assign
        $admin->assignRole($adminRole);


        // Default admin role
        $managerRole = Role::create(
            [
                'name' => 'manager',
                'parent_id' => $admin->id,
            ]
        );
        // Default admin permissions
        $managerPermissions = [
            'manage user',
            'create user',
            'edit user',
            'delete user',
            'manage contact',
            'create contact',
            'edit contact',
            'delete contact',
            'manage support',
            'create support',
            'edit support',
            'delete support',
            'reply support',
            'manage note',
            'create note',
            'edit note',
            'delete note',
            'manage category',
            'create category',
            'edit category',
            'delete category',
            'manage logged history',
            'manage service',
            'create service',
            'edit service',
            'delete service',
            'manage customer',
            'create customer',
            'edit customer',
            'delete customer',
            'manage employee',
            'create employee',
            'edit employee',
            'delete employee',
            'manage appointment',
            'create appointment',
            'edit appointment',
            'delete appointment',
            'show appointment',
            'create payment',

        ];
        foreach($managerPermissions as $ap)
        {
            $permission = Permission::findByName($ap);
            $managerRole->givePermissionTo($permission);
        }
        // Default admin
        $manager = User::create(
            [
                'name' => 'Manager',
                'email' => 'manager@gmail.com',
                'password' => Hash::make('123456'),
                'type' => 'manager',
                'lang' => 'english',
                'profile' => 'avatar.png',
                'subscription' => 0,
                'parent_id' => $admin->id,
            ]
        );
        // Default admin role assign
        $manager->assignRole($managerRole);


        // Default Employee role
        $employeeRole = Role::create(
            [
                'name' => 'employee',
                'parent_id' => $admin->id,
            ]
        );
        // Default admin permissions
        $employeePermissions = [
            'manage contact',
            'create contact',
            'edit contact',
            'delete contact',
            'manage support',
            'create support',
            'edit support',
            'delete support',
            'reply support',
            'manage note',
            'create note',
            'edit note',
            'delete note',
            'manage appointment',
            'show appointment',
        ];
        foreach($employeePermissions as $ap)
        {
            $permission = Permission::findByName($ap);
            $employeeRole->givePermissionTo($permission);
        }

// Default Customer role
        $customerRole = Role::create(
            [
                'name' => 'customer',
                'parent_id' => $admin->id,
            ]
        );
        // Default admin permissions
        $customerPermissions = [
            'manage contact',
            'create contact',
            'edit contact',
            'delete contact',
            'manage support',
            'create support',
            'edit support',
            'delete support',
            'reply support',
            'manage note',
            'create note',
            'edit note',
            'delete note',
            'manage appointment',
            'show appointment',
        ];
        foreach($customerPermissions as $ap)
        {
            $permission = Permission::findByName($ap);
            $customerRole->givePermissionTo($permission);
        }
    }
}
