<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Appointment extends Model
{
    use HasFactory;
    protected $fillable=[
        'appointment_id',
        'category',
        'service',
        'user_id',
        'customer_id',
        'date',
        'start_time',
        'end_time',
        'status',
        'payment_date',
        'amount',
        'payment_details',
        'payment_method',
        'payment_status',
        'notes',
        'parent_id',
    ];

    public function categories(){
        return $this->hasOne('\App\Models\Category','id','category');
    }

    public function services(){
        return $this->hasOne('\App\Models\Service','id','service');
    }
    public function employees(){
        return $this->hasOne('\App\Models\User','id','user_id');
    }
    public function customers(){
        return $this->hasOne('\App\Models\User','id','customer_id');
    }

    public static $status=[
        'pending'=>'Pending',
        'approved'=>'Approved',
        'completed'=>'Completed',
        'rejected'=>'Rejected',
        'cancelled'=>'Cancelled',
    ];

    public static $payment_status=[
        'unpaid'=>'Unpaid',
        'paid'=>'Paid',
    ];

    public static $payment_method=[
        'cash'=>'Cash',
        'bank'=>'Bank',
        'cheque'=>'Cheque',
        'upi'=>'UPI',
    ];
}
