<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Service;
use App\Models\Subscription;
use Illuminate\Http\Request;

class ServiceController extends Controller
{

    public function index()
    {
        if (\Auth::user()->can('manage service')) {
            $services = Service::where('parent_id', '=', \Auth::user()->id)->get();
            return view('service.index', compact('services'));
        } else {
            return redirect()->back()->with('error', __('Permission Denied!'));
        }
    }


    public function create()
    {
        $categories = Category::where('parent_id', '=', \Auth::user()->id)->get()->pluck('title','id');
        $categories->prepend(__('Select Category'),'');
        return view('service.create',compact('categories'));
    }


    public function store(Request $request)
    {
        if (\Auth::user()->can('create service')) {
            $validator = \Validator::make(
                $request->all(), [
                'title' => 'required',
                'category' => 'required',
                'fees' => 'required',
                'duration' => 'required',
            ]
            );
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();

                return redirect()->back()->with('error', $messages->first());
            }

            $ids = \Auth::user()->parentId();
            $authUser = \App\Models\User::find($ids);
            $total_service = $authUser->totalService();
            $subscription = Subscription::find($authUser->subscription);
            if ($total_service < $subscription->total_service || $subscription->total_service == 0) {
                $service = new Service();
                $service->title = $request->title;
                $service->fees = $request->fees;
                $service->duration = $request->duration;
                $service->category = $request->category;
                $service->description = $request->description;
                $service->parent_id = \Auth::user()->id;
                $service->save();

                return redirect()->back()->with('success', __('Service successfully created!'));
            }else {
                return redirect()->back()->with('error', __('Your service limit is over, Please upgrade your subscription.'));
            }

        } else {
            return redirect()->back()->with('error', __('Permission Denied!'));
        }
    }


    public function show(Service $service)
    {
        //
    }


    public function edit(Service $service)
    {
        $categories = Category::where('parent_id', '=', \Auth::user()->id)->get()->pluck('title','id');
        $categories->prepend(__('Select Category'),'');
        return view('service.edit',compact('categories','service'));
    }


    public function update(Request $request, Service $service)
    {
        if (\Auth::user()->can('edit service')) {
            $validator = \Validator::make(
                $request->all(), [
                'title' => 'required',
                'category' => 'required',
                'fees' => 'required',
                'duration' => 'required',
            ]
            );
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();

                return redirect()->back()->with('error', $messages->first());
            }

            $service->title = $request->title;
            $service->fees = $request->fees;
            $service->duration = $request->duration;
            $service->category = $request->category;
            $service->description = $request->description;
            $service->save();

            return redirect()->back()->with('success', __('Service successfully updated!'));
        } else {
            return redirect()->back()->with('error', __('Permission Denied!'));
        }
    }


    public function destroy(Service $service)
    {
        if (\Auth::user()->can('delete service')) {
            $service->delete();
            return redirect()->back()->with('success', 'Service successfully deleted!');
        } else {
            return redirect()->back()->with('error', __('Permission Denied!'));
        }
    }


}
