<?php

namespace App\Http\Controllers;
use App\Models\Appointment;
use App\Models\Category;
use App\Models\Contact;
use App\Models\Custom;
use App\Models\NoticeBoard;
use App\Models\Order;
use App\Models\Service;
use App\Models\Subscription;
use App\Models\Support;
use App\Models\User;
use Carbon\Carbon;

class HomeController extends Controller
{
    public function index()
    {
        if (\Auth::check()) {
            if (\Auth::user()->type == 'super admin') {
                $data['totalOrganization'] = User::where('type', 'admin')->count();
                $data['totalSubscription'] = Subscription::count();
                $data['totalTransaction'] = Order::count();
                $data['totalIncome'] = Order::sum('price');
                $data['totalNote'] = NoticeBoard::where('parent_id', \Auth::user()->id)->count();
                $data['totalContact'] = Contact::where('parent_id', \Auth::user()->id)->count();
                $data['totalSupport'] = Support::where('created_id', \Auth::user()->id)->orWhere('assign_user', \Auth::user()->id)->count();
                $data['todaySupport'] = Support::whereDate('created_at', '=', date('Y-m-d'))->where('created_id', \Auth::user()->id)->orWhere('assign_user', \Auth::user()->id)->count();

                $data['organizationByMonth'] = $this->organizationByMonth();
                $data['paymentByMonth'] = $this->paymentByMonth();

                return view('dashboard.super_admin', compact('data'));
            } else {

                $data['totalEmployee'] = User::where('parent_id', \Auth::user()->parentId())->whereNotIn('type', ['employee'])->count();
                $data['totalCustomer'] = User::where('parent_id', \Auth::user()->parentId())->whereNotIn('type', ['customer'])->count();
                $data['totalAppointment'] = Appointment::where('parent_id', \Auth::user()->parentId())->count();
                $data['todayAppointment'] =  Appointment::where('date',date('Y-m-d'))->where('parent_id', \Auth::user()->parentId())->count();
                $data['totalCategory'] = Category::where('parent_id', \Auth::user()->parentId())->count();
                $data['totalServices'] = Service::where('parent_id', \Auth::user()->parentId())->count();

                $data['totalContact'] = Contact::where('parent_id', \Auth::user()->id)->count();
                $data['totalSupport'] = Support::where('created_id', \Auth::user()->id)->orWhere('assign_user', \Auth::user()->id)->count();
                $data['todaySupport'] = Support::whereDate('created_at', '=', date('Y-m-d'))->where('created_id', \Auth::user()->id)->orWhere('assign_user', \Auth::user()->id)->count();
                $data['settings']=Custom::settings();
                $data['appointments']=$this->getAppointment();

                return view('dashboard.index', compact('data'));
            }
        } else {
            if (!file_exists(storage_path() . "/installed")) {
                header('location:install');
                die;
            } else {

                return view('layouts.landing');
            }

        }

    }

    public function organizationByMonth()
    {
        $start = strtotime(date('Y-01'));
        $end = strtotime(date('Y-12'));

        $currentdate = $start;

        $organization = [];
        while ($currentdate <= $end) {
            $organization['label'][] = date('M-Y', $currentdate);

            $month = date('m', $currentdate);
            $year = date('Y', $currentdate);
            $organization['data'][] = User::where('type', 'admin')->whereMonth('created_at', $month)->whereYear('created_at', $year)->count();
            $currentdate = strtotime('+1 month', $currentdate);
        }


        return $organization;

    }

    public function paymentByMonth()
    {
        $start = strtotime(date('Y-01'));
        $end = strtotime(date('Y-12'));

        $currentdate = $start;

        $payment = [];
        while ($currentdate <= $end) {
            $payment['label'][] = date('M-Y', $currentdate);

            $month = date('m', $currentdate);
            $year = date('Y', $currentdate);
            $payment['data'][] = Order::whereMonth('created_at', $month)->whereYear('created_at', $year)->sum('price');
            $currentdate = strtotime('+1 month', $currentdate);
        }

        return $payment;

    }


    public function getAppointment()
    {
        $arrDuration = [];
        $previous_week = strtotime("-2 week +1 day");
        for($i = 0; $i < 14; $i++)
        {
            $arrDuration[date('Y-m-d', $previous_week)] = date('d-M', $previous_week);
            $previous_week                              = strtotime(date('Y-m-d', $previous_week) . " +1 day");
        }

        $arrTask          = [];
        $arrTask['label'] = [];
        $arrTask['data']  = [];
        foreach($arrDuration as $date => $label)
        {

            $data               = Appointment::select(\DB::raw('count(*) as total'))->whereDate('date', $date)->first();
            $arrTask['label'][] = $label;
            $arrTask['data'][]  = $data->total;
        }

        return $arrTask;
    }
}
