<?php

namespace App\Http\Controllers;

use App\Models\EmployeeDetail;
use App\Models\EmployeeService;
use App\Models\Service;
use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;

class EmployeeController extends Controller
{

    public function index()
    {
        $user = \Auth::user();
        if (\Auth::user()->can('manage employee')) {
            $employees = User::where('parent_id', '=', $user->parentId())->whereIn('type', ['employee'])->get();
        } else {
            return redirect()->back()->with('error', __('Permission Denied!'));
        }

        return view('employee.index', compact('employees'));
    }


    public function create()
    {
        $days=EmployeeDetail::$days;
        $services=Service::where('parent_id',\Auth::user()->parentId())->get()->pluck('title','id');

        return view('employee.create',compact('days','services'));
    }


    public function store(Request $request)
    {
        if (\Auth::user()->can('create employee')) {
            $validator = \Validator::make(
                $request->all(), [
                    'name' => 'required',
                    'email' => 'required|email|unique:users',
                    'password' => 'required|min:6',
                    'phone_number' => 'required',
                    'start_time' => 'required',
                    'end_time' => 'required',
                    'break_start_time' => 'required',
                    'break_end_time' => 'required',
                    'padding_time' => 'required',
                    'working_days' => 'required',
                    'services' => 'required',
                ]
            );
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();

                return redirect()->back()->with('error', $messages->first());
            }


            $role_r = Role::where('name','employee')->where('parent_id',\Auth::user()->parentId())->first();
            $employee = new User();
            $employee->name = $request->name;
            $employee->email = $request->email;
            $employee->phone_number = $request->phone_number;
            $employee->password = \Hash::make($request->password);
            $employee->type = $role_r->name;
            $employee->profile = 'avatar.png';
            $employee->lang = 'english';
            $employee->parent_id = \Auth::user()->parentId();
            $employee->save();
            $employee->assignRole($role_r);

            if(!empty($employee)){
                $empDetail=new EmployeeDetail();
                $empDetail->user_id=$employee->id;
                $empDetail->start_time=$request->start_time;
                $empDetail->end_time=$request->end_time;
                $empDetail->break_start_time=$request->break_start_time;
                $empDetail->break_end_time=$request->break_end_time;
                $empDetail->padding_time=$request->padding_time;
                $empDetail->working_days=!empty($request->working_days)?implode(',',$request->working_days):'';
                $empDetail->parent_id=\Auth::user()->parentId();
                $empDetail->save();

                foreach ($request->services as $k=>$id){
                    $services=Service::find($id);
                    $service=new EmployeeService();
                    $service->user_id=$employee->id;
                    $service->category=$services->category;
                    $service->service=$id;
                    $service->save();
                }
            }

            return redirect()->route('employees.index')->with('success', __('Employee successfully created!'));
        } else {
            return redirect()->back()->with('error', __('Permission Denied!'));
        }
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $employee=User::find($id);
        $empDetail=EmployeeDetail::where('user_id',$id)->first();
        $empService=EmployeeService::where('user_id',$id)->get()->pluck('service','id');

        $days=EmployeeDetail::$days;
        $services=Service::where('parent_id',\Auth::user()->parentId())->get()->pluck('title','id');

        return view('employee.edit',compact('days','services','employee','empDetail','empService'));
    }


    public function update(Request $request, $id)
    {
        if (\Auth::user()->can('edit employee')) {
            $validator = \Validator::make(
                $request->all(), [
                    'name' => 'required',
                    'email' => 'required|email|unique:users,email,' . $id,
                    'phone_number' => 'required',
                    'start_time' => 'required',
                    'end_time' => 'required',
                    'break_start_time' => 'required',
                    'break_end_time' => 'required',
                    'padding_time' => 'required',
                    'working_days' => 'required',
                ]
            );
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();

                return redirect()->back()->with('error', $messages->first());
            }

            $employee = User::find($id);
            $employee->name = $request->name;
            $employee->email = $request->email;
            $employee->phone_number = $request->phone_number;
            $employee->save();

            if(!empty($employee)){
                $empDetail=EmployeeDetail::where('user_id',$employee->id)->first();
                $empDetail->start_time=$request->start_time;
                $empDetail->end_time=$request->end_time;
                $empDetail->break_start_time=$request->break_start_time;
                $empDetail->break_end_time=$request->break_end_time;
                $empDetail->padding_time=$request->padding_time;
                $empDetail->working_days=!empty($request->working_days)?implode(',',$request->working_days):'';
                $empDetail->save();
            }

            return redirect()->route('employees.index')->with('success', __('Employee successfully updated!'));
        } else {
            return redirect()->back()->with('error', __('Permission Denied!'));
        }
    }


    public function destroy($id)
    {
        if (\Auth::user()->can('delete employee')) {
            $employee = User::find($id);
            $employee->delete();

            EmployeeDetail::where('user_id',$id)->delete();
            EmployeeService::where('user_id',$id)->delete();

            return redirect()->route('employees.index')->with('success', __('Employee successfully deleted!'));
        } else {
            return redirect()->back()->with('error', __('Permission Denied!'));
        }
    }
}
