<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;

class CustomerController extends Controller
{

    public function index()
    {
        $user = \Auth::user();
        if (\Auth::user()->can('manage customer')) {
            $customers = User::where('parent_id', '=', $user->parentId())->whereIn('type', ['customer'])->get();
        } else {
            return redirect()->back()->with('error', __('Permission Denied!'));
        }

        return view('customer.index', compact('customers'));
    }


    public function create()
    {
        return view('customer.create');
    }


    public function store(Request $request)
    {
        if (\Auth::user()->can('create customer')) {
            $validator = \Validator::make(
                $request->all(), [
                'name' => 'required',
                'email' => 'required|email|unique:users',
                'phone_number' => 'required',
            ]
            );
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();

                return redirect()->back()->with('error', $messages->first());
            }


            $role_r = Role::where('name','customer')->where('parent_id',\Auth::user()->parentId())->first();
            $customer = new User();
            $customer->name = $request->name;
            $customer->email = $request->email;
            $customer->phone_number = $request->phone_number;
            $customer->password = \Hash::make(123456);
            $customer->type = $role_r->name;
            $customer->profile = 'avatar.png';
            $customer->lang = 'english';
            $customer->parent_id = \Auth::user()->parentId();
            $customer->save();

            $customer->assignRole($role_r);

            return redirect()->route('customers.index')->with('success', __('Customer successfully created!'));
        } else {
            return redirect()->back()->with('error', __('Permission Denied!'));
        }
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $customer = User::findOrFail($id);

        return view('customer.edit', compact('customer'));
    }


    public function update(Request $request, $id)
    {
        if (\Auth::user()->can('edit customer')) {
            $validator = \Validator::make(
                $request->all(), [
                    'name' => 'required',
                    'email' => 'required|email|unique:users,email,' . $id,
                    'phone_number' => 'required',
                ]
            );
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();

                return redirect()->back()->with('error', $messages->first());
            }

            $customer = User::find($id);
            $customer->name = $request->name;
            $customer->email = $request->email;
            $customer->phone_number = $request->phone_number;
            $customer->save();

            return redirect()->route('customers.index')->with('success', __('Customer successfully updated!'));
        } else {
            return redirect()->back()->with('error', __('Permission Denied!'));
        }
    }


    public function destroy($id)
    {
        if (\Auth::user()->can('delete customer')) {
            $customer = User::find($id);
            $customer->delete();

            return redirect()->route('customers.index')->with('success', __('Customer successfully deleted!'));
        } else {
            return redirect()->back()->with('error', __('Permission Denied!'));
        }
    }
}
